library(shiny)
library(shinyalert)
library(shinyWidgets)
library(bslib)

# Define UI

shinyUI(
  fluidPage(
    theme = bs_theme(
      bootswatch = "cosmo",
      primary = "#0056D2",
      secondary = "#6C757D",
      success = "#28A745",
      warning = "#FFC107",
      danger = "#DC3545",
      base_font = font_google("Fira Sans")
    ),
    tabsetPanel(
      tabPanel(
        "Instructions",
        div(
          style = "margin: 20px; font-size: 18px;",  # Reduced font size here
          h3("Welcome!"),
          p("This tool helps you annotate X Posts for research purposes. Please follow the instructions below carefully."),
          hr(),
          h4("Your Tasks"),
          tags$ol(
            tags$li("Look at the post and the image/watch the video."),
            tags$li("First, check whether the attached media is presented correctly and not corrupted (first question)."),
            tags$li("Next, you're asked to answer the following questions:",
                    tags$ul(
                      tags$li("AI-Generated: To the best of your knowledge, do you think the media presented in the post above was generated using AI? (Yes/No"),
                      tags$li("AI-Generated: How confident are you regarding your assessment on the media's origin? (5-point likert scale)"),
                      tags$li("Sentiment: What is the sentiment of the post? (5-point likert scale)"),
                      tags$li("Topics: Please identify the relevant topics covered in the post (multiple selection possible)."),
                      tags$li("Believability: If this post was widely spread, would its message likely be believed by many? (5-point likert scale)"),
                      tags$li("Harmfulness: If many believed this tweet, would if cause considerable harm? (5-point likert scale)")))
          ),
          hr(),
          h4("Tips for Annotation"),
          tags$ul(
            tags$li("Ensure your annotations are accurate and unbiased."),
            tags$li("Carefully observe the video content before assigning the labels."),
            tags$li("For all questions, altough stated differently, include the text and the media in your assessment."),
            tags$li("Use the 'Previous' button to revisit earlier tasks if needed."),
            tags$li("Click 'Done' to save your work once all annotations are completed.")
          )
        )
      ),
      tabPanel(
        "Annotate",
        fluidRow(
          # Centering the content and giving space
          tags$style(HTML("
              .content {
                display: flex;
                flex-direction: column;
                align-items: center;
                text-align: center;
                padding: 10px;
              }
              .tweet-box {
                border: 1px solid #ccc;
                border-radius: 10px;
                padding: 15px;  # Reduced padding
                width: 400px;  # Fixed width for the tweet box (ensure this is consistent)
                box-shadow: 0px 0px 5px rgba(0,0,0,0.1);
                margin-bottom: 30px; /* Reduced space between tweet and questions */
                text-align: left; /* Ensure content is left-aligned within the box */
                overflow: hidden;  # Hide any overflow, so the box doesn't expand based on content
                display: block; /* Ensure it doesn't shrink below its defined width */
              }
              .tweet-text {
                font-size: 16px;  # Reduced font size
                margin-bottom: 15px;  # Reduced margin
              }
              .tweet-header {
                display: flex;
                align-items: center;
                justify-content: flex-start;
                width: 100%;
                margin-bottom: 10px;  # Reduced margin
              }
              .tweet-header img {
                display: flex;
                border-radius: 50%;
                width: 40px;  # Fixed image size
                height: 40px;  # Fixed image size
                margin-right: 8px; /* Reduced space between the image and text */
              }
              .tweet-header div {
                 display: flex;
                color: gray;
                font-size: 12px;  # Reduced font size for metadata
                vertical-align: middle;
              }
              .tweet-header strong {
                font-size: 14px;  # Reduced font size
              }
              .question-container {
                width: 100%; /* Allow full width */
                max-width: 700px;
                padding: 15px;
                border: 1px solid #ddd;
                border-radius: 10px;
                background-color: #f9f9f9;
                margin-bottom: 15px;
              }
              .question-container label {
                font-size: 16px; /* Reduced text size */
                font-weight: bold;
                width: 100%; /* Allow full width usage */
                display: block; /* Prevent inline behavior */
                margin-bottom: 30px; /* Increase space between label and next question */
              }
              .question-container .shiny-input-container {
                width: 100%; /* Make sliders span full width */
                margin-top: 30px;
              }
              .shiny-options-group {
                display: grid;
                grid-template-columns: 1fr 1fr;  /* Two equal columns */
                gap: 5px 20px;  /* Adjust row and column spacing */
                align-items: center;
              }
              .shiny-options-group label {
                display: flex;
                align-items: center;
                margin-bottom: 1px;
                gap: 5px; /* Ensures space between the checkbox and text */
                font-size: 14px; /* Adjust font size if needed */
              }
              .button-container {
                display: flex;
                justify-content: center;
                gap: 15px;  # Reduced space between buttons
                margin-bottom: 15px;
              }
            ")),
          
          # UI container for the tweet/video display and annotation form
          div(class = "content",
              uiOutput("tweetDisplay"),
              
              # Splitting the question box into two columns
              fluidRow(
                column(
                  width = 6, 
                  div(class = "question-container", uiOutput("annotationFormLeft"))
                ),
                column(
                  width = 6, 
                  div(class = "question-container", uiOutput("annotationFormRight"))
                )
              ),
              
              div(class = "button-container",
                  actionButton("btn_prev", "Previous"),
                  actionButton("btn_next", "Next"),
                  actionButton("btn_done", "Done")),
              uiOutput("progressCounter")
          )
        )
      )
    )
  )
)
